const express = require('express');
const router = express.Router();
const connectDB = require('../config/db');

// GET /authTypes - fetch all auth types from MySQL
router.get('/', async (req, res) => {
    try {
        const db = await connectDB();
        const [rows] = await db.execute('SELECT * FROM auth_types');
        res.json(rows);
        await db.end();
    } catch (err) {
        console.error('Error fetching categories:', err);
        res.status(500).json({ error: 'Failed to fetch categories' });
    }
});


module.exports = router;