
/**
 * @swagger
 * tags:
 *   name: json
 *   description: API for JSON data
 */


/**
 * @swagger
 * /json:
 *   get:
 *     summary: Get a JSON test message
 *     description: Returns a message and a hint for using the /json/users/random/{number} endpoint.
 *     tags:
 *       - json
 *     responses:
 *       200:
 *         description: A JSON message with a hint
 *         content:
 *           application/json:
 *             schema:
 *               type: object
 *               properties:
 *                 message:
 *                   type: string
 *                 hint:
 *                   type: string
 */
const express = require('express');
const router = express.Router();

const usersRouter = require('./users');

router.get('/', (req, res) => {
    res.json({
        message: 'This endpoint is used to return custom JSON data for testing purposes.',
        hint: 'try /json/users/random/{number of users to return} for user data.'
    });
});

router.use('/users', usersRouter);

module.exports = router;