
const app = require('./app');
const connectDB = require('./config/db');
const path = require('path');

const port = process.env.PORT || 3001;

// Connect to MongoDB, then start server
connectDB().then(() => {
  app.get('/', (req, res) => {
    res.sendFile(path.join(__dirname, 'index.html'));
  });
  app.listen(port, () => {
    console.log(`Server running on port ${port}`);
  });
});

