const JokeAPIHandler = require('./jokeapi');

class EndpointHandler {

    constructor(provider) {
        switch (provider) {
            case 'jokeapi':
                this.provider = new JokeAPIHandler();
                break;
            default:
                throw new Error('Unsupported provider');
        }
    }

    formatResult(data) {
        return this.provider.formatResult(data);
    }
}

module.exports = EndpointHandler;