const express = require('express');
const router = express.Router();
const connectDB = require('../config/db');

// GET /categories - fetch all categories from MySQL
router.get('/', async (req, res) => {
    try {
        const db = await connectDB();
        const [rows] = await db.execute('SELECT * FROM categories');
        res.json(rows);
        await db.end();
    } catch (err) {
        console.error('Error fetching categories:', err);
        res.status(500).json({ error: 'Failed to fetch categories' });
    }
});


// POST /categories - add a new category
router.post('/', async (req, res) => {
    const { name, description } = req.body;
    if (!name || !description) {
        return res.status(400).json({ error: 'Category name and description are required' });
    }
    try {
        const db = await connectDB();
        const [result] = await db.execute(
            'INSERT INTO categories (name, description) VALUES (?, ?)',
            [name, description]
        );
        res.status(201).json({ id: result.insertId, name, description });
        await db.end();
    } catch (err) {
        console.error('Error adding category:', err);
        res.status(500).json({ error: 'Failed to add category' });
    }
});



module.exports = router;