const express = require('express');
const router = express.Router();
const connectDB = require('../config/db');
const axios = require('axios');
const EndpointHandler = require('../services/endpointsHandlers/endpointHandler');

connectDB();

router.get('/', (req, res) => {
    res.send('Please check /categories then pass a category here!');
});

router.get('/:subCategoryId', async (req, res) => {
    const subCategoryId = req.params.subCategoryId.trim();

    try {
        if (subCategoryId) {
            const db = await connectDB();
            const [rows] = await db.execute('SELECT * FROM endpoints WHERE subCategoryId = ?', [subCategoryId]);
            if (rows.length) {
                // TODO: handle for each for more than one result
                const endpoint = rows[0].endpoint;
                const response = await axios.get(endpoint);
                let data = response.data;
                data = new EndpointHandler('jokeapi').formatResult(data);

                res.json(data);
                await db.end();
            } else {
                res.status(404).send('No content found for this subcategory');
                await db.end();
            }

        } else {
            return res.status(400).send('Subcategory parameter is required');
        }

    } catch (err) {
        console.error('Error fetching content:', err);
        res.status(500).send('Failed to fetch content');
    }



});

module.exports = router;
