const express = require('express');
const router = express.Router();
const connectDB = require('../config/db');

// GET /subCategories - fetch all subCategories from MySQL
router.get('/:categoryId', async (req, res) => {

    const categoryId = req.params.categoryId.trim();
    try {
        const db = await connectDB();
        const [rows] = await db.execute('SELECT * FROM sub_categories WHERE categoryId = ?', [categoryId]);

        res.json(rows);
        await db.end();
    } catch (err) {
        console.error('Error fetching subcategories:', err);
        res.status(500).json({ error: 'Failed to fetch subcategories' });
    }
});




// POST /subCategories - add a new subCategory
router.post('/', async (req, res) => {
    const { name, description, categoryId } = req.body;
    if (!name || !description || !categoryId) {
        return res.status(400).json({ error: 'Subcategory name, description, and categoryId are required' });
    }
    try {
        const db = await connectDB();
        const [result] = await db.execute(
            'INSERT INTO sub_categories (name, description, categoryId) VALUES (?, ?, ?)',
            [name, description, categoryId]
        );
        res.status(201).json({ id: result.insertId, name, description, categoryId });
        await db.end();
    } catch (err) {
        console.error('Error adding subcategory:', err);
        res.status(500).json({ error: 'Failed to add subcategory' });
    }
});

module.exports = router;